<?php
# WebLogin 3.1
# for EVO CMS 3.x
# german translated version
#
# Created By Raymond Irving 2004
# Modfied for EVO CMS 3.x by info@b-4-u.de 2021-2023
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

defined('IN_PARSER_MODE') or die();

# load tpl
if(is_numeric($tpl))
	$tpl = ($doc=$modx->getDocuments($tpl)) ? $doc['content']:"Dokument '$tpl' nicht gefunden!";
else if ($tpl)
	$tpl = (((substr(strtolower($tpl), 0, 5) == "@file") && ($chunk=file_get_contents(MODX_BASE_PATH.trim(substr($tpl, 6))))) || ($chunk=$modx->getChunk($tpl))) ? $chunk:"Chunk '$tpl' not found.";

if(!$tpl)
	$tpl = getWebLogintpl();

// extract declarations
$declare = webLoginExtractDeclarations($tpl);
$tpls = explode((isset($declare["separator"]) ? $declare["separator"]:"<!--tpl_separator-->"),$tpl);

if(!isset($_SESSION['webValidated'])){
	ob_start();
	$uid = isset($_POST['username'])? htmlspecialchars(trim($_POST['username']), ENT_NOQUOTES):'';
?>
<script type="text/JavaScript">
<!--//--><![CDATA[//><!--
	function getElementById(id){
		var o, d=document;
		if (d.layers) {o=d.layers[id];if(o) o.style=o};
		if (!o && d.getElementById) o=d.getElementById(id);
		if (!o && d.all) o = d.all[id];
		return o;
	}
	function webLoginShowForm(i){
		var a = getElementById('WebLoginLayer0');
		var b = getElementById('WebLoginLayer2');
		if(i==1 && a && b) {
			a.style.display="block";
			b.style.display="none";
			document.forms['loginreminder'].txtpwdrem.value = 0;
		}
		else if(i==2 && a && b) {
			a.style.display="none";
			b.style.display="block";
			document.forms['loginreminder'].txtpwdrem.value = 1;
		}
	};
	function webLoginCheckRemember () {
		if(document.loginfrm.rememberme.value==1) {
			document.loginfrm.rememberme.value=0;
		} else {
			document.loginfrm.rememberme.value=1;
		}
	}
	function webLoginEnter(nextfield,event) {
		if(event && event.keyCode == 13) {
			if(nextfield.name=='cmdweblogin') {
				document.loginfrm.submit();
				return false;
			}
			else {
				nextfield.focus();
				return false;
			}
		} else {
			return true;
		}
	}
//--><!]]>
</script>
<?php
// display login
$ref = isset($_REQUEST["refurl"]) ? array("refurl" => urlencode($_REQUEST["refurl"])) : array();
$tpl = "<div id='WebLoginLayer0' style='position:relative'>".$tpls[0]."</div>";
$tpl.= "<div id='WebLoginLayer2' style='position:relative;display:none'>".$tpls[2]."</div>";
$tpl = str_replace("[+action+]",preserveUrl($modx->documentIdentifier,"",$ref),$tpl);
$tpl = str_replace("[+rememberme+]",($_POST['rememberme'] ? 1 : 0),$tpl);
$tpl = str_replace("[+username+]",$uid,$tpl);
$tpl = str_replace("[+checkbox+]",($_POST['rememberme'] ? "checked='checked'" : ""),$tpl);
$tpl = str_replace("[+logintext+]",$loginText,$tpl);
echo $tpl;

if($focusInput) {
?>
<script type="text/javascript">
	if (document.loginfrm) <?php echo !empty($uid) ? "document.loginfrm.password.focus()" : "document.loginfrm.username.focus()" ?>;
</script>
<?php
};

	$output .= ob_get_contents();
	ob_end_clean();
} else {
	$output= '';
	$itemid = isset($_REQUEST['id']) && is_numeric($_REQUEST['id']) ? $_REQUEST['id'] : 'NULL' ;
	$lasthittime = $modx->time;
	$a = 998;

	$sql = "REPLACE INTO ".$modx->getFullTableName('active_users')." (internalKey, username, lasthit, action, id) values(-{$_SESSION['webInternalKey']}, '{$_SESSION['webShortname']}', '{$lasthittime}', '{$a}', {$itemid})";
	$modx->db->query($sql);

	$modx->updateValidatedUserSession();

	// display logout
	$tpl = $tpls[1];
	$url = preserveUrl($modx->documentObject['id']);
	$url = $url.((strpos($url,"?")===false) ? "?":"&amp;")."webloginmode=lo";
	$tpl = str_replace("[+action+]",$url,$tpl);
	$tpl = str_replace("[+logouttext+]",$logoutText,$tpl);
	$output .= $tpl;
}

# Returns Default WebLogin tpl
function getWebLogintpl(){
	ob_start();
?>
<!-- #declare:separator <hr> --> 
<!-- login form section-->
<style type="text/css">
	.wlForm{
		background-color: #fff;
		border-radius: 3px;
		margin: 0px;
		padding: 2px 3px;
	}
	.wlCell{
		text-align: left;
		height: 28px;
	}
</style>
<form class="wlForm" method="post" name="loginfrm" action="[+action+]"> 
	<input type="hidden" value="[+rememberme+]" name="rememberme" /> 
	<table border="0" cellspacing="0" cellpadding="0">
		<tr>
			<td>
				<table border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td class="wlCell"><b>Benutzer:&nbsp;</b></td>
						<td class="wlCell"><input type="text" name="username" tabindex="1" onkeypress="return webLoginEnter(document.loginfrm.password);" size="8" style="width: 150px;" value="[+username+]" /></td>
					</tr>
					<tr>
						<td class="wlCell"><b>Kennwort:&nbsp;</b></td>
						<td class="wlCell"><input type="password" name="password" tabindex="2" onkeypress="return webLoginEnter(document.loginfrm.cmdweblogin);" style="width: 150px;" value="" /></td>
					</tr>
					<!-- deprecated
					<tr />
						<td class="wlCell">&nbsp;</td>
						<td class="wlCell"><label for="chkbox" style="cursor:pointer">
						&nbsp;Dauerhaft anmelden&nbsp;<input type="checkbox" id="chkbox" name="chkbox" tabindex="4" size="1" value="" [+checkbox+] onclick="webLoginCheckRemember()" /></label></td>
					</tr>
					-->
					<tr>
						<td align="right" colspan="2">
							<br />
							<div style="float: left;"><a href="#" onclick="webLoginShowForm(2);return false;">Kennwort vergessen?</a></div>
							<input type="submit" value="[+logintext+]" name="cmdweblogin" />
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</form>
<hr>
<!-- log out hyperlink section -->
<a href='[+action+]'>[+logouttext+]</a>
<hr>
<!-- Password reminder form section -->
<form class="wlForm" name="loginreminder" method="post" action="[+action+]">
	<input type="hidden" name="txtpwdrem" value="0" />
	<table border="0">
		<tr>
			<td><b>E-Mail:</b></td>
			<td><input type="text" name="txtwebemail" size="24" /></td>
		</tr>
		<tr>
			<td align="right" colspan="2">
				<input type="submit" value="Kennwort senden" name="cmdweblogin" />
				<input type="reset" value="Abbrechen" name="cmdcancel" onclick="webLoginShowForm(1);" />
			</td>
		</tr>
	</table>
</form>
<?php
$t = ob_get_contents();
ob_end_clean();
return $t;
}
?>
